{
 "cells": [
  {
   "cell_type": "code",
   "execution_count": 1,
   "id": "d1916594",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "Defaulting to user installation because normal site-packages is not writeable\n",
      "Requirement already satisfied: numpy in ./.local/lib/python3.9/site-packages (1.21.2)\n",
      "Requirement already satisfied: pandas in ./.local/lib/python3.9/site-packages (1.3.3)\n",
      "Requirement already satisfied: matplotlib in ./.local/lib/python3.9/site-packages (3.4.3)\n",
      "Requirement already satisfied: python-dateutil>=2.7.3 in ./.local/lib/python3.9/site-packages (from pandas) (2.8.2)\n",
      "Requirement already satisfied: pytz>=2017.3 in ./.local/lib/python3.9/site-packages (from pandas) (2021.3)\n",
      "Requirement already satisfied: kiwisolver>=1.0.1 in ./.local/lib/python3.9/site-packages (from matplotlib) (1.3.2)\n",
      "Requirement already satisfied: pyparsing>=2.2.1 in ./.local/lib/python3.9/site-packages (from matplotlib) (2.4.7)\n",
      "Requirement already satisfied: pillow>=6.2.0 in ./.local/lib/python3.9/site-packages (from matplotlib) (8.4.0)\n",
      "Requirement already satisfied: cycler>=0.10 in ./.local/lib/python3.9/site-packages (from matplotlib) (0.10.0)\n",
      "Requirement already satisfied: six in /usr/lib/python3/dist-packages (from cycler>=0.10->matplotlib) (1.10.0)\n"
     ]
    }
   ],
   "source": [
    "!pip install numpy pandas matplotlib"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "cbb75005",
   "metadata": {},
   "source": [
    "\n",
    "# Why Use NumPy?\n",
    "```\n",
    "In Python we have lists that serve the purpose of arrays, but they are slow to process.\n",
    "\n",
    "NumPy aims to provide an array object that is up to 50x faster than traditional Python lists.\n",
    "\n",
    "The array object in NumPy is called ndarray, it provides a lot of supporting functions that make working with ndarray very easy.\n",
    "\n",
    "Arrays are very frequently used in data science, where speed and resources are very important.\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "ccd46888",
   "metadata": {},
   "source": [
    "## Pre-requisites:\n",
    "python installed , know basics of python"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 2,
   "id": "00a915ef",
   "metadata": {},
   "outputs": [],
   "source": [
    "import numpy as np\n",
    "import pandas as pd\n",
    "import matplotlib.pyplot as plt"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 3,
   "id": "b76ba387",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([1, 2, 3, 4, 5])"
      ]
     },
     "execution_count": 3,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "#simple numpy arr:\n",
    "arr = np.array([1, 2, 3, 4, 5]) \n",
    "arr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 4,
   "id": "06bd54ca",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "numpy.ndarray"
      ]
     },
     "execution_count": 4,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "type(arr)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 13,
   "id": "5cd42c78",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "1"
      ]
     },
     "execution_count": 13,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr = np.array((1, 2, 3, 4, 5))\n",
    "#using a tuple\n",
    "arr.ndim"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 6,
   "id": "6c6e40d7",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([1, 2, 3, 4, 5])"
      ]
     },
     "execution_count": 6,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 7,
   "id": "f4e3ec9d",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array(42)"
      ]
     },
     "execution_count": 7,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr = np.array(42)\n",
    "arr"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "073d4f62",
   "metadata": {},
   "source": [
    "# 2-d array numpy"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 15,
   "id": "639ac370",
   "metadata": {},
   "outputs": [],
   "source": [
    "arr = np.array([[1, 2, 3], [4, 5, 6]])"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 16,
   "id": "0264f1d5",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "(array([[1, 2, 3],\n",
       "        [4, 5, 6]]),\n",
       " 2)"
      ]
     },
     "execution_count": 16,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr , arr.ndim"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 17,
   "id": "a308c296",
   "metadata": {},
   "outputs": [],
   "source": [
    "arr = np.array([[[1, 2, 3], [4, 5, 6]], [[1, 2, 3], [4, 5, 6]]])"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 18,
   "id": "bd3ac04f",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[[1, 2, 3],\n",
       "        [4, 5, 6]],\n",
       "\n",
       "       [[1, 2, 3],\n",
       "        [4, 5, 6]]])"
      ]
     },
     "execution_count": 18,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 19,
   "id": "75ee2c56",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "3"
      ]
     },
     "execution_count": 19,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr.ndim"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 20,
   "id": "a7f9fb86",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[1, 2, 3],\n",
       "       [4, 5, 6]])"
      ]
     },
     "execution_count": 20,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr[1]"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 21,
   "id": "8ad0eacf",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "1"
      ]
     },
     "execution_count": 21,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr[0,0,0]"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 22,
   "id": "ad70ba7a",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([1, 2, 3])"
      ]
     },
     "execution_count": 22,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr[0,0]"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 24,
   "id": "0c58eaa0",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "Last element from 2nd dim:  10\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([[1,2,3,4,5], [6,7,8,9,10]])\n",
    "print('Last element from 2nd dim: ', arr[1, -1]) "
   ]
  },
  {
   "cell_type": "markdown",
   "id": "6c0ffca6",
   "metadata": {},
   "source": [
    "## Slicing arrays\n",
    "```\n",
    "Slicing in python means taking elements from one given index to another given index.\n",
    "\n",
    "We pass slice instead of index like this: [start:end].\n",
    "\n",
    "We can also define the step, like this: [start:end:step]. \n",
    "```"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 27,
   "id": "0252dd82",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([4, 6])"
      ]
     },
     "execution_count": 27,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5, 6, 7])\n",
    "arr[3:6:2]"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 28,
   "id": "539f6884",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[5 6 7]\n"
     ]
    }
   ],
   "source": [
    "print(arr[4:]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 29,
   "id": "2717c8e1",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[5 6]\n"
     ]
    }
   ],
   "source": [
    "print(arr[-3:-1]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 30,
   "id": "47ddeb0a",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[2 4]\n"
     ]
    }
   ],
   "source": [
    "print(arr[1:5:2]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 32,
   "id": "5b8b519a",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[7 8 9]\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([[1, 2, 3, 4, 5], [6, 7, 8, 9, 10]])\n",
    "\n",
    "print(arr[1, 1:4]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 33,
   "id": "2707467e",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[3 8]\n"
     ]
    }
   ],
   "source": [
    "print(arr[0:2, 2]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 34,
   "id": "1b102901",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[[2 3 4]\n",
      " [7 8 9]]\n"
     ]
    }
   ],
   "source": [
    "print(arr[0:2, 1:4]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 38,
   "id": "4f4a44ec",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[42  2  3  4  5]\n",
      "[1 2 3 4 5]\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5])\n",
    "x = arr.copy()\n",
    "arr[0] = 42\n",
    "\n",
    "print(arr)\n",
    "print(x) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 40,
   "id": "329f9058",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[42  2 26  4  5]\n",
      "[42  2 26  4  5]\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5])\n",
    "x = arr.view()\n",
    "arr[0] = 42\n",
    "x[2]=26\n",
    "print(arr)\n",
    "print(x) "
   ]
  },
  {
   "cell_type": "markdown",
   "id": "99da455d",
   "metadata": {},
   "source": [
    "# shape"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 42,
   "id": "3c3c210b",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "(2, 4)\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([[1, 2, 3, 4], [5, 6, 7, 8]])\n",
    "\n",
    "print(arr.shape) "
   ]
  },
  {
   "cell_type": "markdown",
   "id": "b226a24b",
   "metadata": {},
   "source": [
    "# Reshaping numpy arrays"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 43,
   "id": "2d221f99",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[ 1,  2,  3],\n",
       "       [ 4,  5,  6],\n",
       "       [ 7,  8,  9],\n",
       "       [10, 11, 12]])"
      ]
     },
     "execution_count": 43,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])\n",
    "\n",
    "newarr = arr.reshape(4, 3)\n",
    "newarr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 44,
   "id": "42133057",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[[ 1,  2],\n",
       "        [ 3,  4],\n",
       "        [ 5,  6]],\n",
       "\n",
       "       [[ 7,  8],\n",
       "        [ 9, 10],\n",
       "        [11, 12]]])"
      ]
     },
     "execution_count": 44,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])\n",
    "\n",
    "newarr = arr.reshape(2, 3, 2)\n",
    "newarr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 45,
   "id": "8822b3b9",
   "metadata": {},
   "outputs": [
    {
     "ename": "ValueError",
     "evalue": "cannot reshape array of size 8 into shape (3,3)",
     "output_type": "error",
     "traceback": [
      "\u001b[0;31m---------------------------------------------------------------------------\u001b[0m",
      "\u001b[0;31mValueError\u001b[0m                                Traceback (most recent call last)",
      "\u001b[0;32m/tmp/ipykernel_25824/1645820940.py\u001b[0m in \u001b[0;36m<module>\u001b[0;34m\u001b[0m\n\u001b[1;32m      1\u001b[0m \u001b[0marr\u001b[0m \u001b[0;34m=\u001b[0m \u001b[0mnp\u001b[0m\u001b[0;34m.\u001b[0m\u001b[0marray\u001b[0m\u001b[0;34m(\u001b[0m\u001b[0;34m[\u001b[0m\u001b[0;36m1\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m2\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m3\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m4\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m5\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m6\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m7\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m8\u001b[0m\u001b[0;34m]\u001b[0m\u001b[0;34m)\u001b[0m\u001b[0;34m\u001b[0m\u001b[0;34m\u001b[0m\u001b[0m\n\u001b[1;32m      2\u001b[0m \u001b[0;34m\u001b[0m\u001b[0m\n\u001b[0;32m----> 3\u001b[0;31m \u001b[0mnewarr\u001b[0m \u001b[0;34m=\u001b[0m \u001b[0marr\u001b[0m\u001b[0;34m.\u001b[0m\u001b[0mreshape\u001b[0m\u001b[0;34m(\u001b[0m\u001b[0;36m3\u001b[0m\u001b[0;34m,\u001b[0m \u001b[0;36m3\u001b[0m\u001b[0;34m)\u001b[0m\u001b[0;34m\u001b[0m\u001b[0;34m\u001b[0m\u001b[0m\n\u001b[0m\u001b[1;32m      4\u001b[0m \u001b[0mnewarr\u001b[0m\u001b[0;34m\u001b[0m\u001b[0;34m\u001b[0m\u001b[0m\n",
      "\u001b[0;31mValueError\u001b[0m: cannot reshape array of size 8 into shape (3,3)"
     ]
    }
   ],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5, 6, 7, 8])\n",
    "\n",
    "newarr = arr.reshape(3, 3)\n",
    "newarr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 56,
   "id": "4d0bc7e2",
   "metadata": {},
   "outputs": [],
   "source": [
    "arr = np.array([1, 2, 3, 4, 5, 6, 7, 8])\n",
    "\n",
    "newarr = arr.reshape(2, 2 , -1)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 57,
   "id": "7754ac1f",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[[1, 2],\n",
       "        [3, 4]],\n",
       "\n",
       "       [[5, 6],\n",
       "        [7, 8]]])"
      ]
     },
     "execution_count": 57,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "newarr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 58,
   "id": "76bc0b44",
   "metadata": {},
   "outputs": [],
   "source": [
    "\n",
    "arr = np.array([[1, 2, 3], [4, 5, 6]])\n",
    "\n",
    "newarr = arr.reshape(-1)\n"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 59,
   "id": "c75ad992",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([1, 2, 3, 4, 5, 6])"
      ]
     },
     "execution_count": 59,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "newarr"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "6c7e77bb",
   "metadata": {},
   "source": [
    "# Iteration"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 60,
   "id": "ed84424b",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "1\n",
      "2\n",
      "3\n"
     ]
    }
   ],
   "source": [
    "\n",
    "arr = np.array([1, 2, 3])\n",
    "\n",
    "for x in arr:\n",
    "  print(x) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 61,
   "id": "52d8a358",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[1 2 3]\n",
      "[4 5 6]\n"
     ]
    }
   ],
   "source": [
    "\n",
    "arr = np.array([[1, 2, 3], [4, 5, 6]])\n",
    "\n",
    "for x in arr:\n",
    "  print(x) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 62,
   "id": "abda555b",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "1\n",
      "2\n",
      "3\n",
      "4\n",
      "5\n",
      "6\n"
     ]
    }
   ],
   "source": [
    "for x in arr:\n",
    "  for y in x:\n",
    "    print(y) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 63,
   "id": "b2a7e309",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "1\n",
      "2\n",
      "3\n",
      "4\n",
      "5\n",
      "6\n",
      "7\n",
      "8\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([[[1, 2], [3, 4]], [[5, 6], [7, 8]]])\n",
    "\n",
    "for x in np.nditer(arr):\n",
    "  print(x) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 72,
   "id": "30d781a6",
   "metadata": {},
   "outputs": [],
   "source": [
    "newarr = arr.reshape((2,-1))"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 73,
   "id": "1861288f",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[1, 2, 3, 4],\n",
       "       [5, 6, 7, 8]])"
      ]
     },
     "execution_count": 73,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "newarr"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "a569dfca",
   "metadata": {},
   "source": [
    "# CONCAT"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 74,
   "id": "1d38d2ce",
   "metadata": {},
   "outputs": [],
   "source": [
    "arr1 = np.array([1, 2, 3])\n",
    "\n",
    "arr2 = np.array([4, 5, 6])\n",
    "\n",
    "arr = np.concatenate((arr1, arr2))\n"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 75,
   "id": "a389a21d",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([1, 2, 3, 4, 5, 6])"
      ]
     },
     "execution_count": 75,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 90,
   "id": "457b1e8d",
   "metadata": {},
   "outputs": [],
   "source": [
    "\n",
    "arr1 = np.array([1, 2])\n",
    "\n",
    "arr2 = np.array([ 3 , 4])\n",
    "\n",
    "arr = np.concatenate((arr1, arr2))"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 91,
   "id": "381e7f49",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([1, 2, 3, 4])"
      ]
     },
     "execution_count": 91,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "arr"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 92,
   "id": "03d49b42",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[0 1 2 3]\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([3, 2, 0, 1])\n",
    "\n",
    "print(np.sort(arr)) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 93,
   "id": "ac1b893d",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "['apple' 'banana' 'cherry']\n"
     ]
    }
   ],
   "source": [
    "\n",
    "arr = np.array(['banana', 'cherry', 'apple'])\n",
    "\n",
    "print(np.sort(arr)) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 94,
   "id": "45d0ca64",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[False  True  True]\n"
     ]
    }
   ],
   "source": [
    "arr = np.array([True, False, True])\n",
    "print(np.sort(arr)) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 95,
   "id": "bd4bf7a0",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[[2 3 4]\n",
      " [0 1 5]]\n"
     ]
    }
   ],
   "source": [
    "\n",
    "arr = np.array([[3, 2, 4], [5, 0, 1]])\n",
    "\n",
    "print(np.sort(arr)) "
   ]
  },
  {
   "cell_type": "markdown",
   "id": "c7d2797c",
   "metadata": {},
   "source": [
    "# Random"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 97,
   "id": "8ef3e1a1",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "[61 17  0 55 56]\n"
     ]
    }
   ],
   "source": [
    "from numpy import random\n",
    "\n",
    "x=random.randint(100, size=(5))\n",
    "\n",
    "print(x) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 99,
   "id": "408a2030",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[28,  8],\n",
       "       [43, 38]])"
      ]
     },
     "execution_count": 99,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "np.random.randint(5,45,size=(2,2))"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 100,
   "id": "ebf1aa00",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([0.32953093, 0.71482222, 0.1688338 , 0.39707273, 0.14726963])"
      ]
     },
     "execution_count": 100,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "np.random.rand(5)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 102,
   "id": "c5f0c399",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([[0.00506386, 0.3616521 , 0.0552562 , 0.7384598 , 0.32950467],\n",
       "       [0.25039153, 0.8533    , 0.57446615, 0.58390255, 0.64109373],\n",
       "       [0.59453228, 0.12555525, 0.11096398, 0.87192633, 0.13840437],\n",
       "       [0.26967402, 0.21818357, 0.61091112, 0.92962446, 0.83784764],\n",
       "       [0.58815646, 0.55521391, 0.09111093, 0.27855426, 0.85958044]])"
      ]
     },
     "execution_count": 102,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "np.random.random(size=(5,5))"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 105,
   "id": "8e55eafe",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([7, 6])"
      ]
     },
     "execution_count": 105,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "np.random.choice([5,6,9,8,7,12,11],size=(2))"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 106,
   "id": "6d7a873e",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "[1, 2, 3, 4, 4, 5, 6, 7]"
      ]
     },
     "execution_count": 106,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "x = [1, 2, 3, 4]\n",
    "y = [4, 5, 6, 7]\n",
    "x+y"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 107,
   "id": "265989ca",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "array([ 5,  7,  9, 11])"
      ]
     },
     "execution_count": 107,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "np.add(x,y)"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "b77d9cdf",
   "metadata": {},
   "source": [
    "# Pandas"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 108,
   "id": "ced8e17d",
   "metadata": {},
   "outputs": [],
   "source": [
    "import pandas as pd"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 120,
   "id": "ea42bb4d",
   "metadata": {},
   "outputs": [],
   "source": [
    "## SERIES \n",
    "\n",
    "a = [1, 7, 2]\n",
    "\n",
    "myvar = pd.Series(a)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 110,
   "id": "6c44691d",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "0    1\n",
       "1    7\n",
       "2    2\n",
       "dtype: int64"
      ]
     },
     "execution_count": 110,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "myvar"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 111,
   "id": "94040e18",
   "metadata": {},
   "outputs": [
    {
     "name": "stdout",
     "output_type": "stream",
     "text": [
      "1\n"
     ]
    }
   ],
   "source": [
    " print(myvar[0]) "
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 112,
   "id": "a663db3c",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "x    1\n",
       "y    7\n",
       "z    2\n",
       "dtype: int64"
      ]
     },
     "execution_count": 112,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "a = [1, 7, 2]\n",
    "\n",
    "myvar = pd.Series(a, index = [\"x\", \"y\", \"z\"])\n",
    "myvar"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 113,
   "id": "b8e48843",
   "metadata": {},
   "outputs": [],
   "source": [
    "calories = {\"day1\": 420, \"day2\": 380, \"day3\": 390}\n",
    "\n",
    "myvar = pd.Series(calories)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 114,
   "id": "1ccc9935",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "day1    420\n",
       "day2    380\n",
       "day3    390\n",
       "dtype: int64"
      ]
     },
     "execution_count": 114,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "myvar"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 115,
   "id": "b4b40c1a",
   "metadata": {},
   "outputs": [],
   "source": [
    "\n",
    "calories = {\"day1\": 420, \"day2\": 380, \"day3\": 390}\n",
    "\n",
    "myvar = pd.Series(calories, index = [\"day1\", \"day2\"])\n"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 116,
   "id": "d6ac38dc",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "day1    420\n",
       "day2    380\n",
       "dtype: int64"
      ]
     },
     "execution_count": 116,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "myvar"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 119,
   "id": "217040d7",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "420"
      ]
     },
     "execution_count": 119,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "myvar['day1']"
   ]
  },
  {
   "cell_type": "markdown",
   "id": "330bda03",
   "metadata": {},
   "source": [
    "# Data Frame"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 126,
   "id": "f683d2d6",
   "metadata": {},
   "outputs": [],
   "source": [
    "\n",
    "data = {\n",
    "  \"calories\": 45,\n",
    "  \"duration\": 50\n",
    "}\n",
    "\n",
    "myvar = pd.DataFrame(data,index=[1])"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 127,
   "id": "4cc9a158",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/html": [
       "<div>\n",
       "<style scoped>\n",
       "    .dataframe tbody tr th:only-of-type {\n",
       "        vertical-align: middle;\n",
       "    }\n",
       "\n",
       "    .dataframe tbody tr th {\n",
       "        vertical-align: top;\n",
       "    }\n",
       "\n",
       "    .dataframe thead th {\n",
       "        text-align: right;\n",
       "    }\n",
       "</style>\n",
       "<table border=\"1\" class=\"dataframe\">\n",
       "  <thead>\n",
       "    <tr style=\"text-align: right;\">\n",
       "      <th></th>\n",
       "      <th>calories</th>\n",
       "      <th>duration</th>\n",
       "    </tr>\n",
       "  </thead>\n",
       "  <tbody>\n",
       "    <tr>\n",
       "      <th>1</th>\n",
       "      <td>45</td>\n",
       "      <td>50</td>\n",
       "    </tr>\n",
       "  </tbody>\n",
       "</table>\n",
       "</div>"
      ],
      "text/plain": [
       "   calories  duration\n",
       "1        45        50"
      ]
     },
     "execution_count": 127,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "myvar"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 128,
   "id": "6f6c11f4",
   "metadata": {},
   "outputs": [],
   "source": [
    "\n",
    "data = {\n",
    "  \"calories\": [420, 380, 390],\n",
    "  \"duration\": [50, 40, 45]\n",
    "}\n",
    "\n",
    "myvar = pd.DataFrame(data)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 129,
   "id": "ae2da7a1",
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/html": [
       "<div>\n",
       "<style scoped>\n",
       "    .dataframe tbody tr th:only-of-type {\n",
       "        vertical-align: middle;\n",
       "    }\n",
       "\n",
       "    .dataframe tbody tr th {\n",
       "        vertical-align: top;\n",
       "    }\n",
       "\n",
       "    .dataframe thead th {\n",
       "        text-align: right;\n",
       "    }\n",
       "</style>\n",
       "<table border=\"1\" class=\"dataframe\">\n",
       "  <thead>\n",
       "    <tr style=\"text-align: right;\">\n",
       "      <th></th>\n",
       "      <th>calories</th>\n",
       "      <th>duration</th>\n",
       "    </tr>\n",
       "  </thead>\n",
       "  <tbody>\n",
       "    <tr>\n",
       "      <th>0</th>\n",
       "      <td>420</td>\n",
       "      <td>50</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>1</th>\n",
       "      <td>380</td>\n",
       "      <td>40</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>2</th>\n",
       "      <td>390</td>\n",
       "      <td>45</td>\n",
       "    </tr>\n",
       "  </tbody>\n",
       "</table>\n",
       "</div>"
      ],
      "text/plain": [
       "   calories  duration\n",
       "0       420        50\n",
       "1       380        40\n",
       "2       390        45"
      ]
     },
     "execution_count": 129,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "myvar"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "id": "211f5eef",
   "metadata": {},
   "outputs": [],
   "source": []
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "id": "48572bdc",
   "metadata": {},
   "outputs": [],
   "source": []
  },
  {
   "cell_type": "markdown",
   "id": "bedc42b8",
   "metadata": {},
   "source": [
    "<img src=\"https://storage.googleapis.com/lds-media/images/series-and-dataframe.width-1200.png\" >"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "id": "07ce394f",
   "metadata": {},
   "outputs": [],
   "source": []
  }
 ],
 "metadata": {
  "kernelspec": {
   "display_name": "Python 3 (ipykernel)",
   "language": "python",
   "name": "python3"
  },
  "language_info": {
   "codemirror_mode": {
    "name": "ipython",
    "version": 3
   },
   "file_extension": ".py",
   "mimetype": "text/x-python",
   "name": "python",
   "nbconvert_exporter": "python",
   "pygments_lexer": "ipython3",
   "version": "3.9.4"
  }
 },
 "nbformat": 4,
 "nbformat_minor": 5
}
